﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Kz.GammaTech.X509;
using Kz.GammaTech.Ocsp;
using Kz.GammaTech.Utilities.Encoders;
using System.IO;

//  Программа, демонстрирующая работу с классом OCSPHelper. Класс предназначен для получения информации
//  о статусе сертификата от сервера OCSP. Запрос осуществляется по протоколу LDAP. У класса имеются свойства:
//  public X509Certificate IssuerCert  - сертификат УЦ, выпустившего проверяемый сертификат   
//  public X509Name IssuerName - DN имя УЦ, выпустившего проверяемый сертификат
//  public X509Name RequestorName -имя сформировавшего запрос
//  public BigInteger SerialNumber - серийный номер проверяемого сертификата
//  public string LdapUrl - URL, на который будет отправлен запрос
//  public int Port - порт, на который будет отправлен запрос
//  public int Status - код статуса сертификатов (заполняется только в случае удачной обработки запроса)
//  public int Reason - код причины отозвания сертификата (заполняется только в случае, если сертификат отозван)
//  public DateTime RevocationDate  - дата отозвания сертификата(заполняется только в случае, если сертификат отозван)
//  Методы:
//  public void CreateRequest(X509Certificate Certificate) -  формирует OCSP-запрос с вложенным в него сертификатом (Certificate)
//  public void CreateRequest() - формирует OCSP-запрос без вложенного сертификата
//  public int SendRequest() - посылает сформированный запрос на сервер и получает ответ. Возвращаемые значения:
//  (0) -- запрос обработан успешно
//  (1) -- некорректный запрос
//  (2) -- внутренняя ошибка
//  (3) -- попробуйте позже
//  (4) -- не используется
//  (5) -- требуется ЭЦП
//  (6) -- неразрешенный запрос
//  public void ParseResponce() - извлекает из OCSP-ответа данные относящиеся к статусу сертификата. Вызов возможен
//  только в случае успешного завершения работы метода SendRequest
//  public byte[] GetRequestEncoded() -  возращает OCSP-запрос в виде массива байт
//  public byte[] GetResponceEncoded() - возвращает OCSP-ответ в виде массива байт

namespace OcspWrapperExample
{
    class Program
    {
        static void Main(string[] args)
        {

            byte[] cert1 = Base64.Decode("MIICYTCCAgqgAwIBAgIgFAxsAx70WlYXzJJJ2qCYho/tE7bzDNDOHb6Vd1FGxVQw"
                                       + "DgYKKwYBBAG1EQECAgUAMFgxCzAJBgNVBAYTAktaMQ8wDQYDVQQIEwZBTE1BVFkx"
                                       + "DjAMBgNVBAoTBUdBTU1BMQ0wCwYDVQQLEwRURVNUMRkwFwYDVQQDDBDQmtCe0KDQ"
                                       + "ndCV0JLQntCZMCIYDzIwMDgwMjI4MTEwMjQ4WhgPMjAxMzAyMjgxMTAyNDhaMC0x"
                                       + "DjAMBgNVBAMTBUtvbHlhMQ4wDAYDVQQKEwVHQU1NQTELMAkGA1UEBhMCS1owYzAO"
                                       + "BgorBgEEAbURAQICBQADUQAGAgAAOqoAAABFQzEAAgAApSRb0FHBh0v0FVJUPQaN"
                                       + "WriI+dhr0TvGAxfY2QqWLDEkEpX7MZzJm1+G0Tt4vsrVr7QtQdTR6BpWHnT+7j2H"
                                       + "kaOBvjCBuzBVBgNVHSMETjBMgCB+3q+PryXXE6FCBDKuC3jwhkIGoOUtbH5Hh+pW"
                                       + "mM9jG6EGhwR/AAABgiB+3q+PryXXE6FCBDKuC3jwhkIGoOUtbH5Hh+pWmM9jGzAp"
                                       + "BgNVHQ4EIgQgFAxsAx70WlYXzJJJ2qCYho/tE7bzDNDOHb6Vd1FGxVQwDgYDVR0P"
                                       + "AQH/BAQDAgEGMAwGA1UdEwQFMAMCAQAwGQYDVR0fBBIwEDAOoAigBocEfwAAAYEC"
                                       + "AWYwDgYKKwYBBAG1EQECAgUAA0EA/8+ze6MMyC9HyTXeBIAAriCFGyoFv9Dm/4kJ"
                                       + "Rm6ymb1fQW9eM5FP6s5lL9aI18HJP+YjpITWf/TnQolWd+0KtQ==");

            byte[] root = Base64.Decode("MIICjTCCAjagAwIBAgIgft6vj68l1xOhQgQyrgt48IZCBqDlLWx+R4fqVpjPYxsw"
                                       + "DgYKKwYBBAG1EQECAgUAMFgxCzAJBgNVBAYTAktaMQ8wDQYDVQQIEwZBTE1BVFkx"
                                       + "DjAMBgNVBAoTBUdBTU1BMQ0wCwYDVQQLEwRURVNUMRkwFwYDVQQDDBDQmtCe0KDQ"
                                       + "ndCV0JLQntCZMCIYDzIwMDgwMjIwMDQ1NTM3WhgPMjAxMzAyMjAyMzU5NTlaMFgx"
                                       + "CzAJBgNVBAYTAktaMQ8wDQYDVQQIEwZBTE1BVFkxDjAMBgNVBAoTBUdBTU1BMQ0w"
                                       + "CwYDVQQLEwRURVNUMRkwFwYDVQQDDBDQmtCe0KDQndCV0JLQntCZMGMwDgYKKwYB"
                                       + "BAG1EQECAgUAA1EABgIAADqqAAAARUMxAAIAAJFsxS61mxvr1eR0fQVFf1B1/Mzz"
                                       + "Ka8kft+Q2x1icMwIOeU3mwKiBMFyYsOhhUWNZWiTnM64KCiT6ESheOOjZA6jgb8w"
                                       + "gbwwEgYDVR0TAQH/BAgwBgEB/wIBAzAOBgNVHQ8BAf8EBAMCAQYwKQYDVR0OBCIE"
                                       + "IH7er4+vJdcToUIEMq4LePCGQgag5S1sfkeH6laYz2MbMGsGA1UdIwRkMGKAIH7e"
                                       + "r4+vJdcToUIEMq4LePCGQgag5S1sfkeH6laYz2MboRyGGmh0dHA6Ly8xOTIuMTY4"
                                       + "LjEwLjEwOjYyMjgwgiB+3q+PryXXE6FCBDKuC3jwhkIGoOUtbH5Hh+pWmM9jGzAO"
                                       + "BgorBgEEAbURAQICBQADQQBw+qOdck8YI/zdRqVem+iw7+3tRUv18Hqo/Fju5Ig4"
                                       + "wZYarkt/kyiy22Y0xJJqdtGN0bbDh6YVn4FIFC6+nnng");
            byte[] root_other = Base64.Decode("MIICTDCCAfWgAwIBAgIg968zgw9j0K+PJrsfya+IUPatnwPG390DvomUBCxN4Qcw"
+"DgYKKwYBBAG1EQECAgUAMC4xCzAJBgNVBAMTAkNBMRIwEAYDVQQKEwlVTkxJTUlU"
+"RUQxCzAJBgNVBAYTAktaMB4XDTA4MTIxMjEwMDczMVoXDTE4MTIxMDEwMDczMVow"
+"LjELMAkGA1UEAxMCQ0ExEjAQBgNVBAoTCVVOTElNSVRFRDELMAkGA1UEBhMCS1ow"
+"YzAOBgorBgEEAbURAQUIBQADUQAGAgAAOqoAAABFQzEAAgAAst/giU+WCiQR75y+"
+"Ths/B12mtxhkNg8vyl/9gapWi8dLu+ZAitFtxGC0cFzk7JAx3ocs3YAQakmPIg9n"
+"FEXQAqOB1jCB0zASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB/wQEAwIBBjAp"
+"BgNVHQ4EIgQg968zgw9j0K+PJrsfya+IUPatnwPG390DvomUBCxN4QcwgYEGA1Ud"
+"IwR6MHiAIPevM4MPY9Cvjya7H8mviFD2rZ8Dxt/dA76JlAQsTeEHoTKkMDAuMQsw"
+"CQYDVQQDEwJDQTESMBAGA1UEChMJVU5MSU1JVEVEMQswCQYDVQQGEwJLWoIg968z"
+"gw9j0K+PJrsfya+IUPatnwPG390DvomUBCxN4QcwDgYKKwYBBAG1EQECAgUAA0EA"
+"Emu6soFNOva7JvkzeFffimgH12wFJ/V5Fn0o9mI4MsTkvspITAJrRgnvWlh6TfuH"
+"vtL9d69kXTa5apaERaSY1Q==");

            byte[] cert_other1 = Base64.Decode("MIIC5TCCAo6gAwIBAgIgG+FKEGLxSaI6nqbsMTFzqmx2YY79QW8FINwfppaoO+Aw"
+"DgYKKwYBBAG1EQECAgUAMC4xCzAJBgNVBAMTAkNBMRIwEAYDVQQKEwlVTkxJTUlU"
+"RUQxCzAJBgNVBAYTAktaMCIYDzIwMDkwMTE0MDU1OTMzWhgPMjAxMDAxMTQwNTU5"
+"MzNaMDIxDzANBgNVBAMTBlVTRVIyNTESMBAGA1UEChMJVU5MSU1JVEVEMQswCQYD"
+"VQQGEwJLWjBjMA4GCisGAQQBtREBBQgFAANRAAYCAAA6qgAAAEVDMQACAADKPMcX"
+"k9LAP9ZaXmQ+usWIdo67rau99epLS2Cwpgdavu5aRKWQu83kkXVnKa23sDFLTF9N"
+"craIQe4bXumlQGpWo4IBZjCCAWIwCwYDVR0PBAQDAgbAMBMGA1UdJQQMMAoGCCsG"
+"AQUFBwMEMGcGA1UdHwRgMF4wLaAroCmGJ2h0dHA6Ly9jYS5raXNjLmt6OjYyMjgw"
+"L2NnaS9SZXZMaXN0LmNybDAtoCugKYYnaHR0cDovL2NhLmtpc2Mua3o6NjIyODAv"
+"Y2dpL1Jldkxpc3QuY3JsMD8GCCsGAQUFBwEBBDMwMTAvBggrBgEFBQcwAYYjbGRh"
+"cDovL2NhLmtpc2Mua3o6NjIyMjIvY2dpL3N0YXR1cwAwKQYDVR0OBCIEIBvhShBi"
+"8UmiOp6m7DExc6psdmGO/UFvBSDcH6aWqDvgMGkGA1UdIwRiMGCAIPevM4MPY9Cv"
+"jya7H8mviFD2rZ8Dxt/dA76JlAQsTeEHoRqGGGxkYXA6Ly9jYS5raXNjLmt6OjYy"
+"MjIyL4Ig968zgw9j0K+PJrsfya+IUPatnwPG390DvomUBCxN4QcwDgYKKwYBBAG1"
+"EQECAgUAA0EAKpYSh9iFsubVWOUODbLd3jeLdKTksdXFIxtZ5/YXqX3xhSosjPBw"
+"YPflIqjjd+K+kwLfSZpKF3p0pAz8uhtKuQ==");

            byte[] cert_other2 = Base64.Decode("MIIC5TCCAo6gAwIBAgIgEwJM/GBeOovxdscAGoqv1OtdFZRdetzO1iPPLdW0nfMw"
+"DgYKKwYBBAG1EQECAgUAMC4xCzAJBgNVBAMTAkNBMRIwEAYDVQQKEwlVTkxJTUlU"
+"RUQxCzAJBgNVBAYTAktaMCIYDzIwMDkwMTE0MDU1OTM2WhgPMjAxMDAxMTQwNTU5"
+"MzZaMDIxDzANBgNVBAMTBlVTRVIyNTESMBAGA1UEChMJVU5MSU1JVEVEMQswCQYD"
+"VQQGEwJLWjBjMA4GCisGAQQBtREBCAgFAANRAAYCAABFoAAAAEVDMQACAABVK4UM"
+"yu8OXKHfv2tN6BaMaMQofDcrWfk3l8kpCynQ7GjCbzfBFFg5wGoQJFspYa/aQzrC"
+"LkfNCiKT5kHRmfCmo4IBZjCCAWIwCwYDVR0PBAQDAgbAMBMGA1UdJQQMMAoGCCsG"
+"AQUFBwMEMGcGA1UdHwRgMF4wLaAroCmGJ2h0dHA6Ly9jYS5raXNjLmt6OjYyMjgw"
+"L2NnaS9SZXZMaXN0LmNybDAtoCugKYYnaHR0cDovL2NhLmtpc2Mua3o6NjIyODAv"
+"Y2dpL1Jldkxpc3QuY3JsMD8GCCsGAQUFBwEBBDMwMTAvBggrBgEFBQcwAYYjbGRh"
+"cDovL2NhLmtpc2Mua3o6NjIyMjIvY2dpL3N0YXR1cwAwKQYDVR0OBCIEIBMCTPxg"
+"XjqL8XbHABqKr9TrXRWUXXrcztYjzy3VtJ3zMGkGA1UdIwRiMGCAIPevM4MPY9Cv"
+"jya7H8mviFD2rZ8Dxt/dA76JlAQsTeEHoRqGGGxkYXA6Ly9jYS5raXNjLmt6OjYy"
+"MjIyL4Ig968zgw9j0K+PJrsfya+IUPatnwPG390DvomUBCxN4QcwDgYKKwYBBAG1"
+"EQECAgUAA0EApyO+gHAdtt97pBLwcWMb/U88LqCfRNCv6vypnQll08LT08EKzbvf"
+"Mva6p42La0B7fuRrnDR9lihiXxcS/dCUHg==");

            byte[] cert_other3 = Base64.Decode("MIIC5TCCAo6gAwIBAgIgT0cXNvEj0BPgIglaulj4tGuZkcH4dpR5US3hJAS/Epww"
+"DgYKKwYBBAG1EQECAgUAMC4xCzAJBgNVBAMTAkNBMRIwEAYDVQQKEwlVTkxJTUlU"
+"RUQxCzAJBgNVBAYTAktaMCIYDzIwMDkwMTEzMDcwMzI0WhgPMjAxMDAxMTMwNzAz"
+"MjRaMDIxDzANBgNVBAMTBlVTRVIyMDESMBAGA1UEChMJVU5MSU1JVEVEMQswCQYD"
+"VQQGEwJLWjBjMA4GCisGAQQBtREBCAgFAANRAAYCAABFoAAAAEVDMQACAAD1gMHR"
+"5xD/i0w/3K4C0WSbO6FrZs/ZHFPgKz+j2le1+dS98xhCMpBHnNNSTGkWrvV0+G0M"
+"DX6TLnzOqZNqGaBVo4IBZjCCAWIwCwYDVR0PBAQDAgbAMBMGA1UdJQQMMAoGCCsG"
+"AQUFBwMEMGcGA1UdHwRgMF4wLaAroCmGJ2h0dHA6Ly9jYS5raXNjLmt6OjYyMjgw"
+"L2NnaS9SZXZMaXN0LmNybDAtoCugKYYnaHR0cDovL2NhLmtpc2Mua3o6NjIyODAv"
+"Y2dpL1Jldkxpc3QuY3JsMD8GCCsGAQUFBwEBBDMwMTAvBggrBgEFBQcwAYYjbGRh"
+"cDovL2NhLmtpc2Mua3o6NjIyMjIvY2dpL3N0YXR1cwAwKQYDVR0OBCIEIE9HFzbx"
+"I9AT4CIJWrpY+LRrmZHB+HaUeVEt4SQEvxKcMGkGA1UdIwRiMGCAIPevM4MPY9Cv"
+"jya7H8mviFD2rZ8Dxt/dA76JlAQsTeEHoRqGGGxkYXA6Ly9jYS5raXNjLmt6OjYy"
+"MjIyL4Ig968zgw9j0K+PJrsfya+IUPatnwPG390DvomUBCxN4QcwDgYKKwYBBAG1"
+"EQECAgUAA0EAjR8qybZKCPdMv8PwS/1V9qaB0gognixrKSu/YbRBSJg87HLpk6Ms"
+"y37hG0BxgnynfQsnPaRTUlqDabGAyD23Tg==");

            byte[] cert_other4 = Base64.Decode("MIIC5TCCAo6gAwIBAgIgc61jkMwY+NIkBd81Op/rqZ6/eJEugAePjI6JCkTFgbkw"
+"DgYKKwYBBAG1EQECAgUAMC4xCzAJBgNVBAMTAkNBMRIwEAYDVQQKEwlVTkxJTUlU"
+"RUQxCzAJBgNVBAYTAktaMCIYDzIwMDkwMTEzMDcwMzIyWhgPMjAxMDAxMTMwNzAz"
+"MjJaMDIxDzANBgNVBAMTBlVTRVIyMDESMBAGA1UEChMJVU5MSU1JVEVEMQswCQYD"
+"VQQGEwJLWjBjMA4GCisGAQQBtREBBQgFAANRAAYCAAA6qgAAAEVDMQACAABvJjQd"
+"QCTGj7ipUG4oLtCD/843yBXjgTqEVledRmdM8vZ4GmeusCj89TojEhbM6/tmqk28"
+"N95VW3fbg8Vwn8NSo4IBZjCCAWIwCwYDVR0PBAQDAgbAMBMGA1UdJQQMMAoGCCsG"
+"AQUFBwMEMGcGA1UdHwRgMF4wLaAroCmGJ2h0dHA6Ly9jYS5raXNjLmt6OjYyMjgw"
+"L2NnaS9SZXZMaXN0LmNybDAtoCugKYYnaHR0cDovL2NhLmtpc2Mua3o6NjIyODAv"
+"Y2dpL1Jldkxpc3QuY3JsMD8GCCsGAQUFBwEBBDMwMTAvBggrBgEFBQcwAYYjbGRh"
+"cDovL2NhLmtpc2Mua3o6NjIyMjIvY2dpL3N0YXR1cwAwKQYDVR0OBCIEIHOtY5DM"
+"GPjSJAXfNTqf66mev3iRLoAHj4yOiQpExYG5MGkGA1UdIwRiMGCAIPevM4MPY9Cv"
+"jya7H8mviFD2rZ8Dxt/dA76JlAQsTeEHoRqGGGxkYXA6Ly9jYS5raXNjLmt6OjYy"
+"MjIyL4Ig968zgw9j0K+PJrsfya+IUPatnwPG390DvomUBCxN4QcwDgYKKwYBBAG1"
+"EQECAgUAA0EAZK55cEx/kSFFjaM/CnFUJlYkSEuEy6Pn3d87Rg1UKMerICktnold"
+"CPt5GBywWhvG5Ytnv5Vr2UT2VY6YgNtvdA==");
                
           

           X509Certificate cert = new X509CertificateParser().ReadCertificate(cert_other4);
           X509Certificate cert_root = new X509CertificateParser().ReadCertificate(root);
           
            // имеется только проверяемый сертификат
            OCSPHelper hlp = new OCSPHelper();
          // необходимо установить след. свойства           
            hlp.RequestorName = cert.SubjectDN;
            hlp.SerialNumber = cert.SerialNumber;
            hlp.CreateRequest(cert);
            FileStream f1 = new FileStream("req1.bin", FileMode.Create);
            f1.Write(hlp.GetRequestEncoded(), 0, hlp.GetRequestEncoded().Length);
            f1.Close();
            int k = hlp.SendRequest(1,"192.168.10.30",62265); // отправка по http
            if (k == 0)
            {
                hlp.ParseResponce();
                
                    if (hlp.Status!= 0) Console.WriteLine("Status is not OK");
                    else Console.WriteLine("Status is OK");
                
            }
            Console.WriteLine("Test1 is OK");
            // имеется сертификат УЦ и  сертификат пользователя
            OCSPHelper hlp1 = new OCSPHelper();
            // необходимо установить след. свойства          
            hlp1.IssuerCert = cert_root;           
            hlp1.RequestorName = cert.SubjectDN;
            hlp1.SerialNumber = cert.SerialNumber;
            hlp1.CreateRequest(cert);
           
            //FileInfo f = new FileInfo();
            FileStream f2 = new FileStream("req2.bin", FileMode.Create);
            f2.Write(hlp1.GetRequestEncoded(), 0, hlp1.GetRequestEncoded().Length);
            f2.Close();

            k = hlp1.SendRequest(0,"192.168.10.30",62222); // отправка по ldap
            if (k == 0)
            {
                hlp1.ParseResponce();
                
                    if (hlp1.Status != 0) Console.WriteLine("Status is not OK");
                    else Console.WriteLine("Status is OK");
               
            }
            Console.WriteLine("Test2 is OK");
            
            // имеется сертификат УЦ и  серийный номер сертификата пользователя
            OCSPHelper hlp2 = new OCSPHelper();
            // необходимо установить след. свойства          
            hlp2.IssuerCert = cert_root;
            hlp2.RequestorName = cert.SubjectDN;
            hlp2.SerialNumber = cert.SerialNumber;
            hlp2.CreateRequest();
            FileStream f3 = new FileStream("req3.bin", FileMode.Create);
            f3.Write(hlp2.GetRequestEncoded(), 0, hlp2.GetRequestEncoded().Length);
            f3.Close();
            k = hlp2.SendRequest(1, "192.168.10.30", 62265);
            if (k == 0)
            {
                hlp2.ParseResponce();
              
                    if (hlp2.Status != 0) Console.WriteLine("Status is not OK");
                    else Console.WriteLine("Status is OK");
                
            }
            Console.WriteLine("Test3 is OK");
            Console.ReadKey();
        }
    }
}
